package edu.upvehu.gbg.http;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.logging.Level;
import java.util.logging.Logger;


public class SimpleWebServer {
    
    private static final int PORT=80;
   
    public static void main(String[] args) {
        ServerSocket ss;
        try {
            ss = new ServerSocket(PORT);
            System.out.println("[WebServer] HTTP Server started on port " + PORT);
            for (int id = 0; true; id++) {
                Socket socket = ss.accept();
                System.out.println("[WebServer] New input connection: HTTPWorker " + id +" -> " + socket);
                new SimpleHTTPWorker(socket, id).start();
            }
        } catch (IOException ex) {
            javax.swing.JOptionPane.showMessageDialog(
					null, 
					"<html>SimpleWebServer<br>Se ha producido un error y el programa se cerrará<br>"+ex.getMessage(), 
					"Error", 
					javax.swing.JOptionPane.ERROR_MESSAGE);
			System.exit(-1);
        }
    }
}

class SimpleHTTPWorker extends Thread {
    
    private final int id;
    private final Socket socket;

    public SimpleHTTPWorker(Socket socket, int id) {
        this.socket = socket;
        this.id = id;
    }
        
	@Override
    public void run() {
        try (
            BufferedReader in = new BufferedReader(new InputStreamReader(socket.getInputStream(),"utf8"));
            PrintWriter out = new PrintWriter(new OutputStreamWriter(socket.getOutputStream(),"utf8"));
        ){
            String host = null, path = null;
            for (String s; !(s = in.readLine()).equals("");) {
                System.out.println("[HTTPWorker " + id +"]: " + s);
                String[] field = s.split(" ");
                if (field[0].equals("GET")) path = field[1];
                else if (field[0].equals("Host:")) host = field[1];
            }
            System.out.println("[HTTPWorker " + id +"]: end of input command, generating response");
            out.println(htmlResponse(host,path));
            out.flush();
        } catch (IOException ex) {
            Logger.getLogger(WebServer.class.getName()).log(Level.SEVERE, null, ex);
        }
    }
    
    private String htmlResponse(String host, String path){
        return  
				"<html>\n\t<body>\n"+
                "\t\t<h1>SimpleWebServer</h1>\n" +
                "\t\t<p>So simple that it just shows your GET method.:<p>\n" +
                "\t\t<ul>\n" +
                "\t\t\t<li>Host: <b>" + host + "</b></li>\n" +
                "\t\t\t<li>Path: <b>" + path + "</b></li>\n" +
                "\t\t</ul>\n" +
                "\t</body>\n</html>\n";
    }
    
}
