package edu.upvehu.gbg.http;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.Socket;

public class HTTP {
    
    public static void printResource(String host, int port, String path) throws IOException{
        
        try (
                Socket socket = new Socket(host,port);
                BufferedReader in = SocketUtil.getInput(socket);
                PrintWriter out = SocketUtil.getOutput(socket);
        ){
            out.print("GET " + path + " HTTP/1.1\r\n");
            out.print("Host: " + host + "\r\n");
            out.print("\r\n");
            out.flush();
            
            for (String s; (s = in.readLine()) != null;)
                System.out.println(s);
                
        }
    }
    
    public static void main(String[] args) throws IOException {
		// http://localhost/German/mkl/adibidea.html
		System.out.println("PIDIENDO /German/Docencia/2526/TAP/ A LOCALHOST\n==========================================");
        HTTP.printResource("localhost",80,"/German/Docencia/2526/TAP/");

		
        // http://gtts.ehu.es:8080/German/mkl/adibidea.html
		System.out.println("PIDIENDO /German/Docencia/2526/TAP/ A gtts.ehu.es:8080\n==========================================");
        HTTP.printResource("gtts.ehu.es",8080,"/German/Docencia/2526/TAP/");

    }
}