<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8"%>
<%@ page import="java.util.List" %>
<%@ page import="com.miweb.modelo.Mensaje" %>

<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Chat MVC</title>
    <!-- Vinculamos el CSS externo -->
    <link rel="stylesheet" type="text/css" href="css/estilos.css">
</head>
<body>

    <div class="chat-container">
        <!-- Cabecera -->
        <div class="header">
            <div class="avatar"></div>
            <div class="contact-info">
                <h3>Contacto MVC</h3>
                <p>en línea</p>
            </div>
        </div>

        <!-- Área de mensajes -->
        <div class="messages-area" id="areaMensajes">
            <% 
                // Recuperamos la lista que el Servlet nos envió
                List<Mensaje> conversacion = (List<Mensaje>) session.getAttribute("historialChat");
                
                if (conversacion != null) {
                    for (Mensaje msg : conversacion) {
                        String claseBurbuja = "enviado".equals(msg.getTipo()) ? "sent" : "received";
            %>
            
                <div class="bubble <%= claseBurbuja %>">
                    <%= msg.getTexto() %>
                    <span class="timestamp">
                        <%= msg.getHora() %>
                        <% if ("enviado".equals(msg.getTipo())) { %>
                            <span class="check-icon">✓✓</span>
                        <% } %>
                    </span>
                </div>
            
            <% 
                    } 
                }
            %>
        </div>

        <!-- Formulario (Footer) -->
        <div class="footer">
            <!-- NOTA: El action apunta al Servlet ('chat'), no al JSP -->
            <form action="chat" method="post">
                <input type="text" name="mensajeUsuario" class="input-box" placeholder="Escribe un mensaje aquí" autocomplete="off" required>
                <button type="submit" class="send-btn">
                    <span class="send-icon"></span>
                </button>
            </form>
        </div>
    </div>

    <script>
        window.onload = function() {
            var area = document.getElementById("areaMensajes");
            if(area) area.scrollTop = area.scrollHeight;
        };
    </script>

</body>
</html>