package com.miweb.controlador;

import com.miweb.modelo.Mensaje;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import jakarta.servlet.ServletException;
import jakarta.servlet.annotation.WebServlet;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;

// Esta anotación define la URL. Accederás al chat como: http://localhost:8080/TuProyecto/chat
@WebServlet("/chat")
public class ChatServlet extends HttpServlet {
    
    // Método GET: Se ejecuta cuando abres la página por primera vez
    @Override
    protected void doGet(HttpServletRequest request, HttpServletResponse response) 
            throws ServletException, IOException {
        
        HttpSession session = request.getSession();
        List<Mensaje> conversacion = (List<Mensaje>) session.getAttribute("historialChat");

        // Inicializar datos si es la primera vez
        if (conversacion == null) {
            conversacion = new ArrayList<>();
            conversacion.add(new Mensaje("¡Hola! ¿Cómo estás?", "recibido", "10:30"));
            conversacion.add(new Mensaje("Todo bien, separando el código en MVC.", "enviado", "10:31"));
            session.setAttribute("historialChat", conversacion);
        }

        // Redirigir a la vista JSP
        request.getRequestDispatcher("/chat.jsp").forward(request, response);
    }

    // Método POST: Se ejecuta cuando envías el formulario
    @Override
    protected void doPost(HttpServletRequest request, HttpServletResponse response) 
            throws ServletException, IOException {
        
        request.setCharacterEncoding("UTF-8");
        String nuevoTexto = request.getParameter("mensajeUsuario");
        HttpSession session = request.getSession();
        
        // Recuperar la lista existente
        List<Mensaje> conversacion = (List<Mensaje>) session.getAttribute("historialChat");
        if (conversacion == null) conversacion = new ArrayList<>();

        if (nuevoTexto != null && !nuevoTexto.trim().isEmpty()) {
            SimpleDateFormat sdf = new SimpleDateFormat("HH:mm");
            String horaActual = sdf.format(new Date());

            // 1. Añadir mensaje del usuario
            conversacion.add(new Mensaje(nuevoTexto, "enviado", horaActual));

            // 2. Lógica de Respuesta Automática (Simulación)
            if (nuevoTexto.toLowerCase().contains("java")) {
                conversacion.add(new Mensaje("¡Java es genial para el backend!", "recibido", horaActual));
            } else if (nuevoTexto.toLowerCase().contains("zip")) {
                conversacion.add(new Mensaje("No puedo crear ZIPs, pero aquí tienes el código.", "recibido", horaActual));
            }
            
            session.setAttribute("historialChat", conversacion);
        }

        // Patrón Post-Redirect-Get: Redirigir al GET para evitar reenvío de formulario al recargar
        response.sendRedirect("chat");
    }
}